USE [AdventureWorks2016]
GO
SET STATISTICS IO ON;
GO 
-----------------------------------------------------
-- Scalar Values
-----------------------------------------------------
SELECT	SalesOrderID,
	OrderDate
FROM	Sales.SalesOrderHeader
WHERE	YEAR(OrderDate) = 2011
AND	MONTH(OrderDate) = 7
GO


SELECT	SalesOrderID,
	OrderDate
FROM	Sales.SalesOrderHeader
WHERE	OrderDate >= '7/1/2011' 
AND		OrderDate < '8/1/2011'
GO


-------------------------------------------------------
-- Complicated Query Plan
-------------------------------------------------------
SELECT	C.CustomerID, C.AccountNumber, H.SalesOrderID, 
		H.OrderDate, D.OrderQty, D.UnitPrice, D.ProductID
FROM	Sales.SalesOrderDetail D
JOIN	Sales.SalesOrderHeader H ON H.SalesOrderID = D.SalesOrderID
JOIN	Sales.Customer C ON C.CustomerID = H.CustomerID
WHERE	H.OrderDate = '2011-10-23' 
ORDER BY D.ProductID


---------------------------------------------------------------
-- Proper data type
---------------------------------------------------------------
SET STATISTICS IO ON
GO
SELECT *
FROM	Sales.Customer
WHERE AccountNumber = N'AW00000557'

SELECT *
FROM	Sales.Customer
WHERE AccountNumber = 'AW00000557'



--------------------------------------------------------------
-- EXISTS
--------------------------------------------------------------
DECLARE @Rows INT

SELECT @Rows = COUNT(*)
FROM	Sales.SalesOrderHeader
WHERE	Status = 5

IF @Rows > 0 PRINT 'Found!'
GO

IF EXISTS (SELECT 1 FROM Sales.SalesOrderHeader WHERE Status = 5)
	PRINT 'Found!'
GO

---------------------------------------------------------------
-- NULLs 
---------------------------------------------------------------


SELECT	Title, COUNT(*)
FROM	Person.Person 
GROUP BY Title
ORDER BY Title 

DECLARE @Title NVARCHAR(8) = NULL; 

SELECT TOP 10 *
FROM	Person.Person
WHERE	Title = @Title;


---------------------------------------------------------------
-- Optional Parameters - COALESCE 
---------------------------------------------------------------
-- Straight SELECT
DECLARE @SalesOrderID INT
SET @SalesOrderID = 43671

SELECT	*
FROM	Sales.SalesOrderHeader
WHERE	SalesOrderID = @SalesOrderID
GO

-- Using COALESCE --------------------------------
DECLARE @SalesOrderID INT
SET @SalesOrderID = 43671
	
SELECT	*
FROM	Sales.SalesOrderHeader
WHERE	SalesOrderID = COALESCE(@SalesOrderID, SalesOrderID)
GO	

-- Using OR @Parm IS NULL ------------------------
DECLARE @SalesOrderID INT
SET @SalesOrderID = 43671
	
SELECT	*
FROM	Sales.SalesOrderHeader
WHERE	SalesOrderID = @SalesOrderID  OR  @SalesOrderID IS NULL
GO	


---------------------------------------------------------------------------------------------
-- OPTIONAL PARAMETERS
---------------------------------------------------------------------------------------------

-- Using COALESCE
DECLARE @SalesOrderID INT,
		@SalesOrderDate DATETIME
		
--SELECT @SalesOrderID = 43761,
--		@SalesOrderDate = NULL  -- '7/3/2006'

SELECT @SalesOrderID = 43761
		, @SalesOrderDate = '2011-10-26'

SELECT 	*
FROM	Sales.SalesOrderHeader
WHERE  ( SalesOrderID = @SalesOrderID OR  @SalesOrderID IS NULL )
AND		OrderDate = COALESCE(@SalesOrderDAte, OrderDate)


DECLARE @SQL NVARCHAR(MAX)

SET @SQL = 'SELECT * FROM Sales.SalesOrderHeader WHERE 1=1 '

IF @SalesOrderID IS NOT NULL
	SET @SQL = @SQL + ' AND	SalesOrderID = @SalesOrderID '

IF @SalesOrderDate IS NOT NULL
	SET @SQL = @SQL + ' AND	OrderDate = @SalesOrderDate '
	
EXEC sp_executesql 
	@SQL, 
	N'@SalesOrderID int, @SalesOrderDate DATETIME', 
	@SalesOrderID, @SalesOrderDate

PRINT @SQL

GO


---------------------------------------------------------------------------------------------
-- ERROR HANDLING
---------------------------------------------------------------------------------------------
SET XACT_ABORT ON;

SELECT 1/0;

INSERT dbo.Table1(Col1)
VALUES ('abc');

-- -- -- -- -- -- -- 

BEGIN TRY
	SELECT 1/0;

	INSERT dbo.Table1(Col1)
	VALUES ('abc');
END TRY
BEGIN CATCH
	PRINT 'An Error!';
	THROW; 
END CATCH

---------------------------------------------------------------------------------------------
-- Common Table Expression
---------------------------------------------------------------------------------------------
;WITH CTE1 AS (
	SELECT *
			, ROW_NUMBER() OVER (PARTITION BY CustomerID ORDER BY OrderDate) AS OrderDateRank
			, ROW_NUMBER() OVER (PARTITION BY CustomerID ORDER BY SubTotal) AS OrderSizeRank
	FROM Sales.SalesOrderHeader
)
SELECT	CustomerID
		,SalesOrderNumber
		,OrderDate
		,OrderDateRank
		,SubTotal
		,OrderSizeRank
		--,*
FROM	CTE1
WHERE	OrderDateRank = 1
OR		OrderSizeRank = 1 
ORDER BY CTE1.CustomerID, CTE1.OrderDateRank, CTE1.OrderSizeRank

---------------------------------------------------------------------------------------------
-- JSON
---------------------------------------------------------------------------------------------
IF OBJECT_ID('tempdb..#person') IS NOT NULL
	DROP TABLE #person;

CREATE TABLE #person (
	PersonID INT PRIMARY KEY,
	JSONData NVARCHAR(MAX),
)

INSERT #person (PersonID, JSONData)
VALUES
	(2, '{"info": { "name": "John", "surname": "Smith" }, "age": 25 }'),
	(5, '{"info": { "name": "Jane", "surname": "Smith" }, "dob": "1993-11-04T12:00:00" }')

SELECT PersonID,
	JSON_VALUE(JSONData, '$.info.name') AS FirstName,
	JSON_VALUE(JSONData, '$.info.surname') AS SurName,
	JSON_VALUE(JSONData, '$.age') AS Age,
	JSON_VALUE(JSONData, '$.dob') AS DOB
FROM	#person 		
